/**************************************************************************************
Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.
***************************************************************************************
$Id: EipObject_ConnectionManager_Public.h 82454 2019-04-12 12:21:29Z kai $:

Description:
  Connection Manager Object definitions

**************************************************************************************/

#ifndef __EIP_OBJECT_CONNECTIONMANAGER_PUBLIC_H
  #define __EIP_OBJECT_CONNECTIONMANAGER_PUBLIC_H

  /*
  ************************************************************
  *  Object specific defines
  ************************************************************
  */

  #define EIP_CM_CLASS_NUMBER 0x06
  #define EIP_CM_REVISION        1
  #define EIP_CM_MAX_INSTANCE    1


  /* Connection parameter */
  #define EIP_CM_PARAM_REDUNDANT_MASK     0x8000
  #define EIP_CM_PARAM_EXCLUSIVE_OWNER    0x0000
  #define EIP_CM_PARAM_REDUNDANT_OWNER    0x8000

  #define EIP_CM_PARAM_TYPE_MASK          0x6000
  #define EIP_CM_PARAM_TYPE_NULL          0x0000
  #define EIP_CM_PARAM_TYPE_MULTICAST     0x2000
  #define EIP_CM_PARAM_TYPE_POINT         0x4000
  #define EIP_CM_PARAM_TYPE_RESERVED      0x6000

  #define EIP_CM_PARAM_PRIORITY_MASK      0x0C00
  #define EIP_CM_PARAM_PRIORITY_LOW       0x0000
  #define EIP_CM_PARAM_PRIORITY_HIGH      0x0400
  #define EIP_CM_PARAM_PRIORITY_SCHEDULED 0x0800
  #define EIP_CM_PARAM_PRIORITY_URGENT    0x0C00

  #define EIP_CM_PARAM_FIXED_VAR_MASK     0x0200
  #define EIP_CM_PARAM_VARIABLE_SIZE      0x0200
  #define EIP_CM_PARAM_FIXED_SIZE         0x0000

  #define EIP_CM_PARAM_SIZE_MASK          0x01FF

  /* transportClass_Trigger */
  #define EIP_CM_TYPTRIG_DIR_MASK         0x80
  #define EIP_CM_TYPTRIG_DIR_CLIENT       0x00
  #define EIP_CM_TYPTRIG_DIR_SERVER       0x80

  #define EIP_CM_TYPTRIG_TRIG_MASK        0x70
  #define EIP_CM_TYPTRIG_TRIG_CYCLIC      0x00
  #define EIP_CM_TYPTRIG_TRIG_COS         0x10
  #define EIP_CM_TYPTRIG_TRIG_APP         0x20

  #define EIP_CM_TYPTRIG_TYP_MASK         0x0F
  #define EIP_CM_TYPTRIG_TYP_CL0          0x00
  #define EIP_CM_TYPTRIG_TYP_CL1          0x01
  #define EIP_CM_TYPTRIG_TYP_CL2          0x02
  #define EIP_CM_TYPTRIG_TYP_CL3          0x03


  /* extended error codes for the connection manager */
  #define EIP_ESR_ALREADY_USED                                    0x100  /* Connection already in use     */
  #define EIP_ESR_BAD_TRANSPORT                                   0x103  /* Transport type not supported  */
  #define EIP_ESR_OWNER_CONFLICT                                  0x106  /* More than one guy configuring */
  #define EIP_ESR_BAD_CONNECTION                                  0x107  /* Trying to close inactive conn */
  #define EIP_ESR_BAD_CONN_TYPE                                   0x108  /* Unsupported connection type   */
  #define EIP_ESR_BAD_CONN_SIZE                                   0x109  /* Connection size mismatch      */

  #define EIP_ESR_CONN_UNCONFIGURED                               0x110  /* Connection unconfigured       */
  #define EIP_ESR_BAD_RPI                                         0x111  /* Unsupportable RPI             */
  #define EIP_ESR_RPI_VALUE_NOT_ACCEPTABLE                        0x112  /* RPI VALUE(S) NOT ACCEPTABLE   */
  #define EIP_ESR_NO_CM_RESOURCES                                 0x113  /* Conn Mgr out of connections   */
  #define EIP_ESR_BAD_VENDOR_PRODUCT                              0x114  /* Mismatch in electronic key    */
  #define EIP_ESR_BAD_DEVICE_TYPE                                 0x115  /* Mismatch in electronic key    */
  #define EIP_ESR_BAD_REVISION                                    0x116  /* Mismatch in electronic key    */
  #define EIP_ESR_BAD_CONN_POINT                                  0x117  /* Nonexistant instance number   */
  #define EIP_ESR_BAD_CONFIGURATION                               0x118  /* Bad config instance number    */
  #define EIP_ESR_CONN_REQ_FAILS                                  0x119  /* No controlling connection opn */
  #define EIP_ESR_NO_APP_RESOURCES                                0x11A  /* App out of connections        */
  #define EIP_ESR_PRODUCTION_INHIBIT_TIME_IS_GREATER_THAN_RPI     0x11B  /* THE PRODUCTION INHIBIT TIME IS GREATER THAN THE RPI
                                                                            The Production Inhibit Time is greater than the Target
                                                                            to Originator RPI. */
  #define EIP_ESR_BAD_TRANSPORT_CLASS                             0x11C  /* The transport class requested in the
                                                                            Transport Type/Trigger parameter is
                                                                            not supported. */

  #define EIP_ESR_BAD_PRODUCTION_TRIGGER                          0x11D  /* The production trigger requested
                                                                            in the Transport Type/Trigger parameter
                                                                            is not supported. */

  #define EIP_ESR_BAD_DIRECTION                                   0x11E  /* The direction requested in the Transport
                                                                            Type/Trigger parameter is not supported. */

  #define EIP_ESR_BAD_O2T_NETWORK_CONN_FIXVAR                     0x11F  /* This extended status code shall be returned
                                                                            as the result of specifying an O2T
                                                                            fixed / variable flag that is not supported. */

  #define EIP_ESR_BAD_T2O_NETWORK_CONN_FIXVAR                     0x120  /* This extended status code shall be returned
                                                                            as the result of specifying a T2O
                                                                            fixed / variable flag that is not supported. */

  #define EIP_ESR_BAD_02T_NETWORK_CONN_PRIORITY                   0x121 /* This extended status code shall be returned
                                                                           as the result of specifying an O2T priority
                                                                           code that is not supported. */

  #define EIP_ESR_BAD_T20_NETWORK_CONN_PRIORITY                   0x122 /* This extended status code shall be returned
                                                                            as the result of specifying a T2O priority
                                                                            code that is not supported. */

  #define EIP_ESR_BAD_02T_NETWORK_CONN_TYPE                       0x123 /* This extended status code shall be returned
                                                                           as the result of specifying an O2T connection
                                                                           type that is not supported */

  #define EIP_ESR_BAD_T2O_NETWORK_CONN_TYPE                       0x124 /* This extended status code shall be returned
                                                                           as the result of specifying a T2O connection
                                                                           type that is not supported */

  #define EIP_ESR_BAD_O2T_NETWORK_CONN_RED_OWNER                  0x125 /* This extended status code shall be returned
                                                                           as the result of specifying an O2T Redundant
                                                                           Owner flag that is not supported */

  #define EIP_ESR_BAD_CONFIG_SIZE                                 0x126 /* This extended status code is returned
                                                                           when the target device determines that
                                                                           the data segment provided in the
                                                                           Connection_Path parameter did not contain
                                                                           an acceptable number of 16-bit words
                                                                           for the the configuration application
                                                                           path requested.*/

  #define EIP_ESR_BAD_O2T_SIZE                                    0x127 /* This extended status code is returned by the
                                                                           target when the size of the consuming object
                                                                           declared in the Forward_Open request and
                                                                           available on the target does not match the
                                                                           size declared in the O->T Network Connection
                                                                           Parameter. */

  #define EIP_ESR_BAD_T2O_SIZE                                    0x128 /* This extended status code is returned by the
                                                                           target when the size of the producing object
                                                                           declared in the Forward Open request and
                                                                           available on the target does not match the
                                                                           size declared in the T->O Network Connection
                                                                           Parameter. */

  #define EIP_ESR_BAD_CONFIG_APPL_PATH                            0x129 /* The configuration application path specified
                                                                           in the connection path does not correspond to
                                                                           a valid configuration application path within
                                                                           the target application. This error could also
                                                                           be returned if a configuration application path
                                                                           was required, but not provided by a connection
                                                                           request */

  #define EIP_ESR_BAD_CONSUMING_APPL_PATH                         0x12A /* The consumed application path specified in the
                                                                           connection path does not correspond to a valid
                                                                           consumed application path within the target
                                                                           application. This error could also be returned
                                                                           if a consumed application path was required,
                                                                           but not provided by a connection request */

  #define EIP_ESR_BAD_PRODUCING_APPL_PATH                         0x12B /* The produced application path specified in the
                                                                           connection path does not correspond to a valid
                                                                           produced application path within the target
                                                                           application. This error could also be returned
                                                                           if a produced application path was required,
                                                                           but not provided by a connection request. */

  #define EIP_ESR_BAD_CONFIG_SYMBOL                               0x12C /* Configuration Symbol does not exist. The
                                                                           originator attempts to connect to a configuration
                                                                           tag name, but the name is not on the list of tags
                                                                           defined on the target. */

  #define EIP_ESR_BAD_CONSUMING_SYMBOL                            0x12D /* Consuming Symbol does not exist. The originator
                                                                           attempts to connect to a consuming tag name, but
                                                                           the name is not on the list of tags defined on the
                                                                           target. */

  #define EIP_ESR_BAD_PRODUCING_SYMBOL                            0x12E /* Producing Symbol does not exist. The originator
                                                                           attempts to connect to a producing tag name, but
                                                                           the name is not on the list of tags defined on the
                                                                           target. */

  #define EIP_ESR_BAD_APPL_PATH_COMBINATION                       0x12F /* The combination of configuration and/or consume
                                                                           and/or produce application paths specified in the
                                                                           connection path are inconsistent with each other */

  #define EIP_ESR_BAD_CONSUME_DATA_FORMAT                         0x130 /* Information in the data segment is not consistent
                                                                           with the format of the consumed data. For example
                                                                           the configuration data specifies float configuration
                                                                           data while the consumed path specifies integer data */

  #define EIP_ESR_BAD_PRODUCE_DATA_FORMAT                         0x131 /* Information in the data segment is not consistent
                                                                           with the format of the produced data. For example the
                                                                           configuration data specifies float configuration data
                                                                           while the produced path specifies integer data. */

  #define EIP_ESR_NULL_FWDOPEN_NOT_SUPPORTED                      0x132 /* The target does not support the function requested by
                                                                           the Null Forward Open. The requested function may be
                                                                           ping a device, configure a devices application, or
                                                                           reconfigure a target devices application. */

  #define EIP_ESR_CONNECTION_TIMEOUT_MULTIPLIER_NOT_ACCEPTABLE    0x133 /* This extended status code shall be returned as the result of specifying a
                                                                           connection timeout multiplier value that is reserved or that produces a timeout
                                                                           value that is too large to support in the device. */

  #define EIP_ESR_MISMATCHED_T2O_NETWORK_CONNECTION_SIZE         0x134  /* This extended status code shall be returned when an originator requests to open
                                                                           a Multicast connection to a T2O application path that is already being
                                                                           produced for another connection and the Size field in the T2O Network
                                                                           Connection Parameters in this request is valid but doesnt match the existing
                                                                           connections Size field. */
  #define EIP_ESR_MISMATCHED_T2O_NETWORK_CONNECTION_FIXVAR       0x135  /* This extended status code shall be returned when an originator requests to open
                                                                           a Multicast connection to a T2O application path that is already being
                                                                           produced for another connection and the Fixed/Variable bit in the T2O
                                                                           Network Connection Parameters in this request is valid but doesnt match the
                                                                           existing connections Fixed/Variable bit. */
  #define EIP_ESR_MISMATCHED_T2O_NETWORK_CONNECTION_PRIORITY     0x136  /* This extended status code shall be returned when an originator requests to open
                                                                           a Multicast connection to a T2O application path that is already being
                                                                           produced for another connection and the Priority field in the T2O Network
                                                                           Connection Parameters in this request is valid but doesnt match the existing
                                                                           connections Priority field. */
  #define EIP_ESR_MISMATCHED_TRANSPORT_CLASS                     0x137  /* This extended status code shall be returned when an originator requests to open
                                                                           a Multicast connection to a T2O application path that is already being
                                                                           produced for another connection and the Transport Class in this request is valid
                                                                           but doesnt match the existing connections Transport Class. */
  #define EIP_ESR_MISMATCHED_T2O_PRODUCTION_TRIGGER              0x138  /* This extended status code shall be returned when an originator requests to open
                                                                           a Multicast connection to a T2O application path that is already being
                                                                           produced for another connection and the T2O Production Trigger in this
                                                                           request is valid but doesnt match the existing connections T2O Production
                                                                           Trigger. */
  #define EIP_ESR_MISMATCHED_T2O_PRODUCTION_INHIBIT_TIME_SEGMENT 0x139  /* This extended status code shall be returned when an originator requests to open
                                                                           a Multicast connection to an application path that is already being produced for
                                                                           another connection and the PIT in this request is valid but doesnt match the
                                                                           existing connections PIT. */


  #define EIP_ESR_CONN_TIMED_OUT                           0x203 /* Using a timed out connection  */
  #define EIP_ESR_UCSEND_TIMED_OUT                         0x204 /* Unconnected Send timed out    */
  #define EIP_ESR_UCSEND_PARAM_ERR                         0x205 /* Unconnected Send param. error */

  #define EIP_ESR_NO_BUFFER                                0x301 /* No buffer memory available    */
  #define EIP_ESR_NO_BANDWIDTH                             0x302 /* Insufficient bandwidth left   */
  #define EIP_ESR_NO_SCREENER                              0x303 /* Out of gen screeners          */
  #define EIP_ESR_NOT_CONF_FOR_RT                          0x304 /* Not configured to send RT data*/
  #define EIP_ESR_SIGNATURE_MISMATCH                       0x305 /* sig does not match sig store in CCM */
  #define EIP_ESR_CCM_NOT_AVAIL                            0x306 /* ccm is not responding to req. */

  #define EIP_ESR_BAD_PORT                                 0x311 /* Nonexistant port              */
  #define EIP_ESR_BAD_LINK_ADDRESS                         0x312 /* Invalid link address in path  */
  #define EIP_ESR_BAD_SEGMENT                              0x315 /* Invalid segment in path       */
  #define EIP_ESR_BAD_CLOSE                                0x316 /* Path & conn not equal in close*/
  #define EIP_ESR_BAD_NET_SEGMENT                          0x317 /* Net seg not present or bad    */
  #define EIP_ESR_BAD_LINK_AD_TO_SELF                      0x318 /* Link address to self invalid  */
  #define EIP_ESR_NO_SEC_RESOURCE                          0x319 /* Resources in secondary unavail*/

  #define EIP_ESR_MISCELLANEOUS                            0x31C /* Miscellaneous error           */
  #define EIP_ESR_REDUND_CONN_MISMATCH                     0x31D /* Redundant connection mismatch */

  #define EIP_ESR_NOT_CONFIGURED_FOR_OFF_SUBNET_MULTICAST  0x813  /* A multicast connection has been requested between a
                                                                     producer and a consumer that are on different subnets,
                                                                     and the producer is not configured for off-subnet multicast. */

#endif
